<?php
/*--------------------------------------------------------------------------------------------------
    OnSellingUnitIdCreateListener.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnit\Database\Listener;

use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\SellingUnit\Unit\Events\Interfaces\OnSellingUnitIdCreateEventInterface;

class OnSellingUnitIdCreateListener
{
    
    /**
     * @var PropertiesReaderServiceInterface
     */
    private $service;
    
    
    /**
     * OnSellingUnitIdCreateListener constructor.
     *
     * @param PropertiesReaderServiceInterface $service
     */
    public function __construct(PropertiesReaderServiceInterface $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param OnSellingUnitIdCreateEventInterface $event
     *
     * @return OnSellingUnitIdCreateEventInterface
     */
    public function __invoke(OnSellingUnitIdCreateEventInterface $event): OnSellingUnitIdCreateEventInterface
    {
        $combinationId = 0;
        
        if ($event->type() === 'product') {
            preg_match("/[\d\{\}]+x(\d+)/", $event->value(), $t_extract);
            if (isset($t_extract[1])) {
                $combinationId = (int)$t_extract[1];
            }
        } elseif ($event->type() === 'info') {
            preg_match("/p[\d\{\}]+x(\d+)_/", $event->value(), $t_extract);
            
            if (isset($t_extract[1])) {
                $combinationId = (int)$t_extract[1];
            }
        } elseif (in_array(strtolower($event->type()),['combi_id', 'combi', 'combid'] )) {
            $combinationId = (int)$event->value();
        }
        if ($combinationId) {
            $this->service->addPropertyInfoToBuilder($combinationId, $event->builder());
        }
        
        return $event;
    }
    
}